/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.api.impl;

import java.util.function.Consumer;
import net.blay09.mods.craftingtweaks.api.ButtonAlignment;
import net.blay09.mods.craftingtweaks.api.ButtonPosition;
import net.blay09.mods.craftingtweaks.api.ButtonStyle;
import net.blay09.mods.craftingtweaks.api.CraftingGrid;
import net.blay09.mods.craftingtweaks.api.CraftingTweaksClientAPI;
import net.blay09.mods.craftingtweaks.api.GridGuiHandler;
import net.blay09.mods.craftingtweaks.api.GridGuiSettings;
import net.blay09.mods.craftingtweaks.api.TweakType;
import net.blay09.mods.craftingtweaks.api.impl.DefaultGridGuiSettings;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_465;
import net.minecraft.class_746;

public class DefaultGridGuiHandler
implements GridGuiHandler {
    @Override
    public void createButtons(class_465<?> screen, CraftingGrid grid, Consumer<class_339> addWidgetFunc) {
        int index;
        GridGuiSettings guiSettings = grid instanceof GridGuiSettings ? (GridGuiSettings)((Object)grid) : new DefaultGridGuiSettings();
        if (this.createTweakButton(screen, grid, addWidgetFunc, guiSettings, index = 0, TweakType.Rotate)) {
            ++index;
        }
        if (this.createTweakButton(screen, grid, addWidgetFunc, guiSettings, index, TweakType.Balance)) {
            ++index;
        }
        this.createTweakButton(screen, grid, addWidgetFunc, guiSettings, index, TweakType.Clear);
    }

    private boolean createTweakButton(class_465<?> screen, CraftingGrid grid, Consumer<class_339> addWidgetFunc, GridGuiSettings guiSettings, int index, TweakType tweak) {
        if (guiSettings.isButtonVisible(tweak)) {
            ButtonPosition buttonPos = guiSettings.getButtonPosition(tweak).orElseGet(() -> this.getAlignedPosition(screen.method_17577(), grid, guiSettings, index));
            addWidgetFunc.accept(CraftingTweaksClientAPI.createTweakButtonRelative(grid, screen, buttonPos.getX(), buttonPos.getY(), tweak, guiSettings.getButtonStyle()));
            return true;
        }
        return false;
    }

    private ButtonPosition getAlignedPosition(class_1703 menu, CraftingGrid grid, GridGuiSettings guiSettings, int index) {
        ButtonAlignment alignment = guiSettings.getButtonAlignment();
        ButtonStyle style = guiSettings.getButtonStyle();
        int offsetX = guiSettings.getButtonAlignmentOffsetX();
        int offsetY = guiSettings.getButtonAlignmentOffsetY();
        class_746 player = class_310.method_1551().field_1724;
        class_1735 firstSlot = (class_1735)menu.field_7761.get(grid.getGridStartSlot((class_1657)player, menu));
        int gridLength = (int)Math.sqrt(grid.getGridSize((class_1657)player, menu));
        return switch (alignment) {
            default -> throw new MatchException(null, null);
            case ButtonAlignment.TOP -> new ButtonPosition(offsetX + firstSlot.field_7873 + style.getSpacingX() * index, offsetY + firstSlot.field_7872 - style.getSpacingY() - style.getMarginY());
            case ButtonAlignment.BOTTOM -> new ButtonPosition(offsetX + firstSlot.field_7873 + style.getSpacingX() * index, offsetY + firstSlot.field_7872 + 18 * gridLength + style.getMarginY());
            case ButtonAlignment.RIGHT -> new ButtonPosition(offsetX + firstSlot.field_7873 + 18 * gridLength + style.getMarginX(), offsetY + firstSlot.field_7872 + style.getSpacingY() * index);
            case ButtonAlignment.LEFT -> new ButtonPosition(offsetX + firstSlot.field_7873 - style.getSpacingX() - style.getMarginX(), offsetY + firstSlot.field_7872 + style.getSpacingY() * index);
        };
    }
}

